/* ***************************************************************************************
* FILE:          DirectTextureConsumer2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DirectTextureConsumer2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DirectTextureConsumer2D_h)
#define DirectTextureConsumer2D_h

#include "Widgets/2D/DirectTextureConsumer/generated/DirectTextureConsumer2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include <Candera/Engine2D/Core/Camera2DListener.h>
#include <Widgets/2D/WidgetGestureConfig.h>

#include "View/CGI/CgiExtensions/RenderJobStrategy.h"

#include <map>

namespace hmibase {
namespace gadget {
namespace videobuffer {
class VideoBufferType;
} // namespace
} // namespace
} // namespace


class DirectTextureConsumer2D : public DirectTextureConsumer2DBase, public Candera::Camera2DListener, public hmibase::view::RenderJobStrategy::RenderJobListener
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      DirectTextureConsumer2D();
      virtual ~DirectTextureConsumer2D();

      CGI_WIDGET_RTTI_DECLARATION(DirectTextureConsumer2D, DirectTextureConsumer2DBase);

      virtual void Update();
      virtual void InitWidget();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void OnPreRender(Candera::Camera2D* camera);
      virtual void OnPostRender(Candera::Camera2D* camera);

      virtual void OnPostSwapBuffer(Courier::Gdu& gdu);

      bool OnTouch(const Candera::Camera2D& camera, const Candera::Vector2& touchedPoint);
      bool OnMessage(const Courier::Message& msg);
      void OnParentViewLoad(bool load);

      virtual bool OnTapGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual WidgetGestureConfig getDefaultGestureConfig() const;

      static void SetSlaveSurfaceConfig(std::map<SlaveSurfaceIdType, bool>& config);

      CdaWidget2DDef(DirectTextureConsumer2D, DirectTextureConsumer2DBase)
      CdaDescription("DirectTextureConsumer2D")
      CdaReadableName("DirectTextureConsumer2D")
      CdaCategory("DirectTexture")

      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:

      class DebugUtil
      {
         public:
            static void Capture(unsigned int instanceId, hmibase::gadget::videobuffer::VideoBufferType* buffer);
         private:
            static bool s_initialized;
            static std::set<unsigned int> s_instanceIdsToDebug;
      };

      enum enGadgetStatus
      {
         NO_CONTENT_AVAILABLE = 0,
         CONTENT_AVAILABLE,
         UNDEFINED = 0xff
      };

      virtual void OnChanged(::FeatStd::UInt32 propertyId);

      void RegisterCameraListener();
      void DeregisterCameraListener();
      void UpdateDRMBuffer(int fb);

      void UpdateNodes(enGadgetStatus status);

      Candera::MemoryManagement::SharedPointer<Candera::Image2D> GetBitmap() const;
      bool IsEffectiveRenderingEnabled();

      /************************************************************************/
      /* return the node on which the gadget content should be placed         */
      /************************************************************************/
      Candera::Node2D* GetBitmapNode() const;

      /************************************************************************/
      /* return the node which should be activated when there is no gadget content available */
      /************************************************************************/
      Candera::Node2D* GetReplacementNode() const;

      bool IsTouchedInstanceValid() const
      {
         return (_touchedInstanceId != -1) ? true : false;
      }

      hmibase::gadget::videobuffer::VideoBufferType* _drmBuffer;
      hmibase::gadget::videobuffer::VideoBufferType* _drmBufferUploaded;

      Candera::Vector2 _slaveSurfacePosition;

      int _touchedInstanceId;

      enGadgetStatus _gadgetContentStatus;

      int _lastProcessedFrameBuffer;

      bool _isRegisteredCameraListenener;

      // surface to sychronize slave surface to
      unsigned int _synchronizedSurface;

      bool _isSlaveSurfaceIdchanged;

      // used for gadget exchange via file on rfs
      std::string _currentFilePath;

      // No Copy
      DirectTextureConsumer2D(const DirectTextureConsumer2D& right);
      DirectTextureConsumer2D& operator=(const DirectTextureConsumer2D& right);
};


#endif // DirectTextureConsumer2D_h
