/* ***************************************************************************************
* FILE:          DelegateWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DelegateWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "DelegateWidget2D.h"
#include <View/CGI/CgiExtensions/AppViewHandler.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BASEWIDGET
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DelegateWidget2D.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {

CGI_WIDGET_RTTI_DEFINITION(DelegateWidget2D);


/*****************************************************************************/
DelegateWidget2D::DelegateWidget2D()
{
   SetTouchable(true);
}


/*****************************************************************************/
DelegateWidget2D::~DelegateWidget2D()
{
}


/*****************************************************************************/
bool DelegateWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned = false;
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const DelegateWidget2D* original = CLONEABLE_WIDGET_CAST<const DelegateWidget2D*>(originalWidget);
      if (original != NULL)
      {
         cloned = true;
      }
   }
   return cloned;
}


}
}
