/* ***************************************************************************************
* FILE:          TraverserBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraverserBase is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TraverserBase_H)
#define TraverserBase_H


/**
 * Base class for a generic traverser.
 */
class TraverserBase
{
   public:
      virtual ~TraverserBase() {};

   protected:
      enum TraverserAction
      {
         ProceedTraversing,              ///< Traversing continues with the next child (if the current node has any) or sibling.
         StopTraversingForDescendants,   ///< Traversing will stop for all child nodes and will continue with the next sibling.
         StopTraversing                  ///< Traversing will stop here.
      };

      /**
       * OnTraverseBegin will be called by the traverser before the traversal starts.
       */
      virtual void OnTraverseBegin()
      {
      }

      /**
       * OnTraverseEnd will be called by the traverser when the traversal has been finished (the exist action is provided as a parameter).
       */
      virtual void OnTraverseEnd(TraverserAction /*exitAction*/)
      {
      }

      /**
       * OnChildProcessing will be called by the traverser before (parameter start is false) an item is processed and after an item is processed (parameter start is true).
       */
      virtual TraverserAction OnChildProcessing(bool /*start*/)
      {
         return ProceedTraversing;
      }
};


#endif
