/* ***************************************************************************************
* FILE:          TVectorEnumerator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TVectorEnumerator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TVectorEnumerator_H)
#define TVectorEnumerator_H

#include "TEnumerator.h"
#include <Courier/Util/Vector.h>

/**
 * The template TVectorEnumerator provides an enumerator implementaion for a Courier::Vector with the same type as the required enumerator.
 */
template<typename T>
class TVectorEnumerator : public TEnumerator<T>::Enumerator
{
      FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

      typedef typename ::TEnumerator<T>::Enumerator Base;
   public:
      explicit TVectorEnumerator(const ::Courier::Vector<T>& items) :
         _items(items),
         _index(-1)
      {
      }

      virtual ~TVectorEnumerator()
      {
      }

      virtual bool MoveNext()
      {
         if (_index + 1 < (FeatStd::Int32) _items.Size())
         {
            ++_index;
            Base::_current = _items[_index];
            return true;
         }
         Base::_current = 0;
         return false;
      }

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(TVectorEnumerator);

      const ::Courier::Vector<T>& _items;
      ::FeatStd::Int32 _index;
};


#endif
