/* ***************************************************************************************
* FILE:          TConvertingVectorEnumerator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TConvertingVectorEnumerator is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TConvertingVectorEnumerator_H)
#define TConvertingVectorEnumerator_H

#include "TEnumerator.h"
#include <Courier/Util/Vector.h>
#include "TVectorEnumerator.h"

/**
 * The template TVectorEnumerator provides an enumerator implementaion for a Courier::Vector with a more general type than the enumerator type.
 * NOTE: items that are not of the enumeration type will be skipped.
 */
template<typename EnumeratorItemType, typename VectorItemType>
class TConvertingVectorEnumerator : public TEnumerator<EnumeratorItemType>::Enumerator
{
      FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

      typedef typename ::TEnumerator<EnumeratorItemType>::Enumerator Base;
   public:
      explicit TConvertingVectorEnumerator(const ::Courier::Vector<VectorItemType>& items) :
         _enumerator(items)
      {
      }

      virtual ~TConvertingVectorEnumerator()
      {
      }

      virtual bool MoveNext()
      {
         while (_enumerator.MoveNext())
         {
            Base::_current = dynamic_cast<EnumeratorItemType>(_enumerator.Current());
            if ((EnumeratorItemType() != Base::_current) || (VectorItemType() == _enumerator.Current()))
            {
               return true;
            }
         }
         Base::_current = 0;
         return false;
      }

   private:
      ::TVectorEnumerator<VectorItemType> _enumerator;
};


#endif
