/* ***************************************************************************************
* FILE:          SourceItem.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SourceItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplateBinding.h"

#include "SourceItem.h"


namespace gccSpecializationHelper {
bool SourceItem<bool>::Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex)
{
   return 0 != ControlTemplateBinding::GetSourceItemAsInteger(source, sourceIndex);
}


Candera::Int32 SourceItem<Candera::Int32>::Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex)
{
   return ControlTemplateBinding::GetSourceItemAsInteger(source, sourceIndex);
}


Candera::String SourceItem<Candera::String>::Get(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex)
{
   return ControlTemplateBinding::GetSourceItemAsString(source, sourceIndex);
}


}
