/* ***************************************************************************************
* FILE:          ReuseCloneCachingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ReuseCloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ReuseCloneCachingStrategy_H)
#define ReuseCloneCachingStrategy_H

#include "CloneCachingStrategy.h"
#include <Candera/System/Rtti/Rtti.h>
#include <FeatStd/Util/ConvenienceMacros.h>

/**
 * The ReuseCloneCachingStrategy will cache ControlTemplateInstance until the next call of Flush.
 */
class ReuseCloneCachingStrategy : public CloneCachingStrategy
{
   public:
      ReuseCloneCachingStrategy();

      virtual ControlTemplateInstancePtr Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations) override;
      virtual void ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index) override;
      virtual bool ProcessBeforeDisposed(ControlTemplateInstance* instance) override;
      virtual void ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex) override;
      virtual void Finalize() override;

   private:
      typedef std::map<tSharedPtrIDataItem, ControlTemplateInstancePtr> ControlTemplateInstanceCache;
      ControlTemplateInstanceCache _cache;
      bool _cacheActive; // used to avoid recursive caching that would lead to stack overflow.

      bool Cache(ControlTemplateInstance* instance);
      void ClearCache();
};


#endif
