/* ***************************************************************************************
* FILE:          LimitedCachingControlTemplateCloningStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LimitedCachingControlTemplateCloningStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(LimitedCachingControlTemplateCloningStrategy_H)
#define LimitedCachingControlTemplateCloningStrategy_H

#include "FixedSizeCloneCachingStrategy.h"

/**
 * The LimitedCachingControlTemplateCloningStrategy template allows you to easily implement a CachingControlTemplateCloningStrategyBase with a limited cache size.
 */
template<size_t _MaxNumberOfInstancesPerTemplate = 20>
class LimitedCachingControlTemplateCloningStrategy : public FixedSizeCloneCachingStrategy
{
   public:
      enum
      {
         MaxNumberOfInstancesPerTemplate = _MaxNumberOfInstancesPerTemplate
      };

   protected:
      virtual FeatStd::UInt32 GetMaxNumberOfInstancesPerTemplate();
};


#endif
