/* ***************************************************************************************
* FILE:          DefaultControlTemplateMap.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultControlTemplateMap is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "CloneProperties.h"

#include <Candera/System/Rtti/Rtti.h>

#include "DefaultControlTemplateMap.h"
#include <Candera/System/Rtti/Rtti.h>

#include "hmi_trace_if.h"
#include "Widgets/widget_etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DefaultControlTemplateMap.cpp.trc.h"
#endif


using namespace Candera;


DefaultControlTemplateMap::DefaultControlTemplateMap() :
   _controlTemplateInstance(0)
{
}


DefaultControlTemplateMap::~DefaultControlTemplateMap()
{
   _controlTemplateInstance = 0;
}


void DefaultControlTemplateMap::Init(ControlTemplateInstance* controlTemplateInstance /*= 0*/)
{
   _controlTemplateInstance = controlTemplateInstance;
}


FeatStd::UInt32 DefaultControlTemplateMap::GetOwnerId() const
{
   return _controlTemplateInstance != NULL ? _controlTemplateInstance->GetOwnerId() : 0;
}


FeatStd::UInt32 DefaultControlTemplateMap::GetIndex() const
{
   return _controlTemplateInstance != NULL ? _controlTemplateInstance->GetIndex() : 0;
}


Candera::Node2D* DefaultControlTemplateMap::ResolveNodeClone(Candera::Node2D* node) const
{
   if ((0 != node) && (!_nodeCloneMap.Empty()))
   {
      const NodeCloneMapping* mappingEntry = Courier::BinarySearch(node, &(_nodeCloneMap[0]), UInt32(_nodeCloneMap.Size()), NodeComparator);
      if (0 != mappingEntry)
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveNodeClone found this = %p", this));
         return mappingEntry->_nodeClone;
      }
   }
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveNodeClone not found this = %p", this));
   return node;
}


void DefaultControlTemplateMap::ResolveNodeCloneArray(Candera::ArrayProperty<Candera::Node2D*>& cloneNodes, const Candera::ArrayProperty<Candera::Node2D*>& originalNodes) const
{
   cloneNodes.Clear();
   if (originalNodes.GetCount() > 0)
   {
      cloneNodes.Reserve(originalNodes.GetCount());
      for (size_t i = 0; i < originalNodes.GetCount(); ++i)
      {
         cloneNodes.Add(ResolveNodeClone(originalNodes.Get(i)));
      }
   }
}


Candera::RenderNode* DefaultControlTemplateMap::ResolveNodeClone(Candera::RenderNode* node) const
{
   Candera::RenderNode* resolvedNode = Candera::Dynamic_Cast<Candera::RenderNode*>(ResolveNodeClone(static_cast<Candera::Node2D*>(node)));
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveNodeClone RN %10s found this = %p", (0 == resolvedNode) ? "not " : "", this));
   return (0 == resolvedNode) ? node : resolvedNode;
}


Candera::Effect2D* DefaultControlTemplateMap::ResolveEffectClone(Candera::Effect2D* effect) const
{
   if ((0 != effect) && (!_effectCloneMap.Empty()))
   {
      const EffectCloneMapping* mappingEntry = Courier::BinarySearch(effect, &(_effectCloneMap[0]), UInt32(_effectCloneMap.Size()), EffectComparator);
      if (0 != mappingEntry)
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveEffectClone found this = %p", this));
         return mappingEntry->_effectClone;
      }
   }
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveEffectClone not found this = %p", this));
   return effect;
}


Candera::WidgetBase* DefaultControlTemplateMap::ResolveWidgetClone(Candera::WidgetBase* widget) const
{
   if ((0 != widget) && (!_widgetCloneMap.Empty()))
   {
      const WidgetCloneMapping* mappingEntry = Courier::BinarySearch(widget, &(_widgetCloneMap[0]), UInt32(_widgetCloneMap.Size()), WidgetComparator);
      if (0 != mappingEntry)
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveWidgetClone found this = %p", this));
         return mappingEntry->_widgetClone;
      }
   }
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "DefaultControlTemplateMap::ResolveWidgetClone not found this = %p", this));
   return widget;
}


void DefaultControlTemplateMap::CloneProperties(const Candera::Widget2D& widget, Candera::Widget2D& widgetClone) const
{
   if (0 != _controlTemplateInstance)
   {
      PropertiesClonners::CloneProperties(widget, widgetClone, *_controlTemplateInstance);
   }
}


void DefaultControlTemplateMap::CloneProperties(const BaseWidget2D& widget, BaseWidget2D& widgetClone) const
{
   if (0 != _controlTemplateInstance)
   {
      PropertiesClonners::CloneProperties(widget, widgetClone, *_controlTemplateInstance);
   }
}


Courier::Int DefaultControlTemplateMap::WidgetComparator(Candera::WidgetBase* widget, const WidgetCloneMapping& mappingEntry)
{
   FEATSTD_LINT_NEXT_EXPRESSION(946, "Relational or subtract operator applied to pointers [MISRA C++ Rule 5-0-15], [MISRA C++ Rule 5-0-17], [MISRA C++ Rule 5-0-18]: changing this would affect the algorithm ");
   return (widget == mappingEntry._widget) ? 0 : (widget < mappingEntry._widget) ? -1 : 1;
}


Courier::Int DefaultControlTemplateMap::NodeComparator(Candera::Node2D* node, const NodeCloneMapping& mappingEntry)
{
   FEATSTD_LINT_NEXT_EXPRESSION(946, "Relational or subtract operator applied to pointers [MISRA C++ Rule 5-0-15], [MISRA C++ Rule 5-0-17], [MISRA C++ Rule 5-0-18]: changing this would affect the algorithm ");
   return (node == mappingEntry._node) ? 0 : (node < mappingEntry._node) ? -1 : 1;
}


Courier::Int DefaultControlTemplateMap::EffectComparator(Candera::Effect2D* effect, const EffectCloneMapping& mappingEntry)
{
   FEATSTD_LINT_NEXT_EXPRESSION(946, "Relational or subtract operator applied to pointers [MISRA C++ Rule 5-0-15], [MISRA C++ Rule 5-0-17], [MISRA C++ Rule 5-0-18]: changing this would affect the algorithm ");

   return (effect == mappingEntry._effect) ? 0 : (effect < mappingEntry._effect) ? -1 : 1;
}


bool DefaultControlTemplateMap::ClonePropertiesInternal()
{
   for (Int i = 0; i < (Int) _widgetCloneMap.Size(); ++i)
   {
      DefaultControlTemplateMap::WidgetCloneMapping& cloneMapping = _widgetCloneMap[i];
      if ((0 != cloneMapping._widget) && (0 != cloneMapping._widgetClone) && (0 != cloneMapping._nodeClone))
      {
         Candera::Widget2D* widget2DClone = cloneMapping._widgetClone->ToBaseWidget2D();
         if (0 != widget2DClone)
         {
            widget2DClone->SetNode(cloneMapping._nodeClone);
         }
         ControlTemplateCloneableWidget* controlTemplateCloneableWidget = CLONEABLE_WIDGET_CAST<ControlTemplateCloneableWidget*>(cloneMapping._widgetClone);
         if (0 != controlTemplateCloneableWidget)
         {
            if (!controlTemplateCloneableWidget->CloneFrom(CLONEABLE_WIDGET_CAST<ControlTemplateCloneableWidget*>(cloneMapping._widget), *this))
            {
               return false;
            }
         }
         else if ((0 == _controlTemplateInstance) ||
                  (
                     (!PropertiesClonners::CloneWidgetCloneProperties<TextAreaWidget2D>(cloneMapping._widget, cloneMapping._widgetClone, *_controlTemplateInstance)) &&
                     (!PropertiesClonners::CloneWidgetCloneProperties<ScrollableTextWidget2DBase>(cloneMapping._widget, cloneMapping._widgetClone, *_controlTemplateInstance)) &&
                     (!PropertiesClonners::CloneWidgetCloneProperties<RichTextBaseWidget2DBase>(cloneMapping._widget, cloneMapping._widgetClone, *_controlTemplateInstance))
                  ))
         {
            // TODO: the following widgets are derived from ControlTemplateCloneableWidget.
            //       But, some of the properties are not cloned because only a base class implements the CloneFrom method.
            //       RadioButtonWidget2D, ToggleButtonWidget2D, ButtonWidget2D, SliderWidget2D and ImageWidget2D
            //       Therefore, the implementation of the CloneFrom method has to be added to these classes.
            return false;
         }
      }
   }
   return true;
}
