/* ***************************************************************************************
* FILE:          DataItem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DataItem_H)
#define DataItem_H

#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <CanderaPlatform/OS/CanderaTypes.h>
#include <Courier/Platform/AtomicOp.h>
#include <CanderaWidget/String/String.h>

// functional include only required for target, lint is not working correctly with this include on host
#ifndef WIN32
#include <functional>
#endif
#include <Candera/System/Rtti/Rtti.h>

class IDataItem;

typedef Candera::MemoryManagement::SharedPointer<IDataItem> tSharedPtrIDataItem;
typedef const char* DataItemContext;

class IDataItem
{
   public:
      FEATSTD_RTTI_DECLARATION();

      IDataItem();
      virtual ~IDataItem();

      virtual Candera::Int32 compare(const IDataItem& item)
      {
         return (this == &item) ? 0 : ((this < &item) ? -1 : 1);
      }

      virtual bool updateDataBindings(bool force) = 0;

      virtual bool isVector() const = 0;

      virtual size_t size() const = 0;

      virtual tSharedPtrIDataItem operator[](size_t index) const = 0;

      virtual operator Candera::Int32() const = 0;

      virtual operator Candera::String() const = 0;

      virtual IDataItem& operator = (Candera::Int32 value) = 0;

      void Retain();

      void Release();
   private:
      Courier::Platform::AtomicOp::Atomic _refCnt; // reference counter for shared pointer
};


namespace std {
template<> struct less<tSharedPtrIDataItem>
{
   bool operator()(const tSharedPtrIDataItem& first, const tSharedPtrIDataItem& second) const
   {
      if (first.GetPointerToSharedInstance() == second.GetPointerToSharedInstance())
      {
         return false;
      }
      if (first.PointsToNull())
      {
         return true; // null objects are the smallest
      }
      if (second.PointsToNull())
      {
         return false;
      }
      return first->compare(*second) < 0;
   }
};


}

#endif
