/* ***************************************************************************************
* FILE:          DataItem.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DataItem is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "DataItem.h"

FEATSTD_RTTI_BASECLASS_DEFINITION(IDataItem);

IDataItem::IDataItem()
{
   *_refCnt = 0;
}


IDataItem::~IDataItem()
{
}


void IDataItem::Retain()
{
   Courier::Platform::AtomicOp::Inc(_refCnt);
}


void IDataItem::Release()
{
   if (Courier::Platform::AtomicOp::Dec(_refCnt) == 0)
   {
      FEATSTD_DELETE(this);
   }
}
