/* ***************************************************************************************
* FILE:          ControlTemplateWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CONTROL_TEMPLATE_WIDGET_H
#define CONTROL_TEMPLATE_WIDGET_H

#include "Widgets/2D/ControlTemplate/generated/ControlTemplateWidget2DBase.h"


/**
 * Use the ControlTemplateWidget2D to set the ControlTemplateBinding properties.
 */
class ControlTemplateWidget2D : public ControlTemplateWidget2DBase
{
   public:
      ControlTemplateWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ControlTemplateWidget2D, ControlTemplateWidget2DBase);

      CdaWidget2DDef(ControlTemplateWidget2D, ControlTemplateWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Candera::UInt32 propertyId);
};


#endif
