/* ***************************************************************************************
* FILE:          ControlTemplateInstanceContainer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateInstanceContainer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ControlTemplateInstanceContainer.h"

#include <Candera/System/Rtti/Rtti.h>
#include "ControlTemplateCloningStrategy.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ControlTemplateInstanceContainer.cpp.trc.h"
#endif
#include <Widgets/2D/List/generated/ListWidget2DBase.h>

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layouter.h>
#endif


class ResetClippingTraverser : public Candera::TreeTraverser2D
{
   public:
      virtual ~ResetClippingTraverser()
      {
      }

   protected:
      virtual TraverserAction ProcessNode(Candera::Node2D& node)
      {
         Candera::RenderNode* renderNode = Candera::Dynamic_Cast<Candera::RenderNode*>(&node);
         if (0 != renderNode)
         {
            renderNode->SetClippingRect();
         }
         return ProceedTraversing;
      }
};


ControlTemplateInstanceContainer::ControlTemplateInstanceContainer(const OwnerInfoRetriever& ownerInfoRetriever) :
   _ownerInfoRetriever(ownerInfoRetriever),
   _itemsGroup(0),
   _cloningStrategy(0)
{
}


ControlTemplateInstanceContainer::~ControlTemplateInstanceContainer()
{
   _itemsGroup = 0;
   _cloningStrategy = 0;
}


void ControlTemplateInstanceContainer::DisposeContent()
{
   Courier::Vector<ControlTemplateInstancePtr>::Iterator it(_controlTemplateInstances.Begin());
   for (; it != _controlTemplateInstances.End(); ++it)
   {
      Candera::Node2D* node((*it)->GetItemRootNode());
      if ((0 != node) && (0 != node->GetParent()))
      {
         static_cast<void>(node->GetParent()->RemoveChild(node));
      }
   }
   _controlTemplateInstances.Clear();
}


void ControlTemplateInstanceContainer::ResetClippingRectangle()
{
   ResetClippingTraverser resetClippingTraverser;
   Courier::Vector<ControlTemplateInstancePtr>::Iterator it(_controlTemplateInstances.Begin());
   for (; it != _controlTemplateInstances.End(); ++it)
   {
      Candera::Node2D* node((*it)->GetItemRootNode());
      if (0 != node)
      {
         resetClippingTraverser.Traverse(*node);
      }
   }
}


Candera::Node2D* ControlTemplateInstanceContainer::AddControlTemplateClone(const ITemplateRetriever& templateRetriever, const tSharedPtrListDataItem& source, FeatStd::UInt32 index)
{
   if (0 != _cloningStrategy)
   {
      ControlTemplateInstancePtr clone = _cloningStrategy->CloneNode(templateRetriever, source, _ownerInfoRetriever.GetOwner(), _ownerInfoRetriever.GetOwnerId(), index);
      if (!clone.PointsToNull())
      {
         if (!_controlTemplateInstances.Contains(clone))
         {
            static_cast<void>(_controlTemplateInstances.Add(clone));
            clone->SetDisposer(_cloningStrategy);
         }
         return clone->GetItemRootNode();
      }
   }
   return 0;
}


void ControlTemplateInstanceContainer::Update(bool invalidateCachedLayout)
{
   Courier::Vector<ControlTemplateInstancePtr> validCTIs;
   for (FeatStd::Int i = 0; i < (FeatStd::Int) _controlTemplateInstances.Size(); ++i)
   {
      if (!_controlTemplateInstances[i].PointsToNull())
      {
         /*     _controlTemplateInstances[i]->Update();
              if (invalidateCachedLayout)*/
         Candera::Node2D* rootNode(_controlTemplateInstances[i]->GetItemRootNode());

         if ((rootNode != 0) && (rootNode->GetParent() != 0))
         {
            /* Candera::Node2D* cachedLayoutNode = _controlTemplateInstances[i]->GetCachedLayoutNode();
             if (cachedLayoutNode != 0)*/
            validCTIs.Add(_controlTemplateInstances[i]);
            _controlTemplateInstances[i]->Update();
            if (invalidateCachedLayout)
            {
               // Candera::Layouter::InvalidateLayout(cachedLayoutNode);
               Candera::Node2D* cachedLayoutNode = _controlTemplateInstances[i]->GetCachedLayoutNode();
               if (cachedLayoutNode != 0)
               {
                  Candera::Layouter::InvalidateLayout(cachedLayoutNode);
               }
            }
         }
      }
   }
   _controlTemplateInstances = validCTIs;

   if (0 != _cloningStrategy)
   {
      if (_controlTemplateInstances.Size() > 0)
      {
         FeatStd::UInt32 firstVisibleIndex = (!_controlTemplateInstances[0].PointsToNull()) ? _controlTemplateInstances[0]->GetIndex() : 0;
         FeatStd::UInt32 lastVisibleIndex = (!_controlTemplateInstances[_controlTemplateInstances.Size() - 1].PointsToNull()) ? _controlTemplateInstances[_controlTemplateInstances.Size() - 1]->GetIndex() : 0;
         _cloningStrategy->Flush(firstVisibleIndex, lastVisibleIndex);
      }
   }
}


bool ControlTemplateInstanceContainer::OnMessage(const Courier::Message& msg)
{
   ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "ControlTemplateInstanceContainer::OnMessage this=%p, msgPtr=%p, msgId=0x%X", this, &msg, msg.GetId()));
   for (FeatStd::Int i = 0; i < (FeatStd::Int) _controlTemplateInstances.Size(); ++i)
   {
      if (!_controlTemplateInstances[i].PointsToNull())
      {
         Candera::Node2D* rootNode(_controlTemplateInstances[i]->GetItemRootNode());

         if ((rootNode != 0) && (rootNode->GetParent() != 0) && (_controlTemplateInstances[i]->OnMessage(msg)))
         {
            return true;
         }
      }
   }
   return false;
}
