/* ***************************************************************************************
* FILE:          ControlTemplateData.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateData is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "TVectorEnumerator.h"

#include "ControlTemplateData.h"

ControlTemplateData::ControlTemplateData() :
   _controlTemplateInstance(0),
   _isTemplateNode(false)
{
}


void ControlTemplateData::SetControlTemplateInstance(ControlTemplateInstance* value)
{
   _controlTemplateInstance = value;
}


ControlTemplateInstance* ControlTemplateData::GetControlTemplateInstance()
{
   return _controlTemplateInstance;
}


void ControlTemplateData::AddAssociatedWidget(Candera::WidgetBase* widget)
{
   static_cast<void>(_associatedWidgets.Add(widget));
}


WidgetBaseEnumerator ControlTemplateData::EnumerateAssociatedWidgets() const
{
   return WidgetBaseEnumerator(CANDERA_NEW(TVectorEnumerator<Candera::WidgetBase*>)(_associatedWidgets));
}


void ControlTemplateData::SetDataContext(const tSharedPtrIDataItem& value)
{
   _dataContext = value;
}


const tSharedPtrIDataItem& ControlTemplateData::GetDataContext() const
{
   return _dataContext;
}


void ControlTemplateData::SetTemplateNode(bool isTemplateNode)
{
   _isTemplateNode = isTemplateNode;
}


bool ControlTemplateData::IsTemplateNode() const
{
   return _isTemplateNode;
}
