/* ***************************************************************************************
* FILE:          ControlTemplateCloneableWidget.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateCloneableWidget is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ControlTemplateCloneableWidget_H)
#define ControlTemplateCloneableWidget_H

#include "ControlTemplateMap.h"

//enable the new behaviour, it it works correctly we remove the old one
#define VARIANT_S_FTR_ENABLE_CLONEABLE_WIDGET

#if defined(VARIANT_S_FTR_ENABLE_CLONEABLE_WIDGET)

typedef Candera::WidgetBase ControlTemplateCloneableWidget;
#define CLONEABLE_WIDGET_CAST Candera::Dynamic_Cast
#define IMPLEMENTS_CLONEABLE_WIDGET

#else

/**
 * The ControlTemplateCloneableWidget interface is used by the control template cloning to delegate property cloning to the widget implementation.
 * A widget has to derive from the ControlTemplateCloneableWidget interface and implement the CloneFrom method.
 * All properties of the widget have to be cloned within this method. Use the ControlTemplateMap to map nodes and widgets to the cloned versions.
 * NOTE: Any more specific widget also has to implement the CloneFrom method and call its base implementation to clone the base properties and afterward
 * clone its properties.
 */
class ControlTemplateCloneableWidget
{
   public:
      /**
       * Implement this method to clone all the widget properties and map cloned nodes and widgets.
       */
      virtual ~ControlTemplateCloneableWidget() {} // dummy for lint 1510
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) = 0;
};


#define CLONEABLE_WIDGET_CAST dynamic_cast
#define IMPLEMENTS_CLONEABLE_WIDGET , public ControlTemplateCloneableWidget

#endif//VARIANT_S_FTR_ENABLE_CLONEABLE_WIDGET

#endif
