/* ***************************************************************************************
* FILE:          ControlTemplateCloneTraverser2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateCloneTraverser2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ControlTemplateCloneTraverser2D_H)
#define ControlTemplateCloneTraverser2D_H

#include <Candera/Engine2D/Core/Node2D.h>
#include "TCloneTraverser.h"
#include "ControlTemplateInstance.h"
#include "DefaultControlTemplateMap.h"
#include "DataItem.h"

/**
 * The ControlTemplateCloneTraverser2D is a cloning traverser for Node2D. It also implements the ControlTemplateMap
 * that is required to implement the implementation ControlTemplateCloneableWidget interface.
 */
class ControlTemplateCloneTraverser2D : public TCloneTraverser<Candera::Node2D>
{
      FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

   public:
      /**
       * The ControlTemplateCloneTraverser2D requires a ControlTemplateInstance store the cloned nodes and widgets and a DataItem to obtain the values for data binding.
       */
      ControlTemplateCloneTraverser2D(ControlTemplateInstance& controlTemplateInstance, const tSharedPtrIDataItem& source, DefaultControlTemplateMap& controlTemplateMap);

   protected:
      virtual TraverserBase::TraverserAction OnClone(const Candera::Node2D& node, Candera::Node2D& nodeClone);
      virtual void OnTraverseEnd(TraverserAction exitAction);
      virtual void OnClear();

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ControlTemplateCloneTraverser2D);

      ControlTemplateInstance& _controlTemplateInstance;
      DefaultControlTemplateMap& _controlTemplateMap;
      tSharedPtrIDataItem _source;
};


#endif
