/* ***************************************************************************************
* FILE:          ControlTemplateBinding.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ControlTemplateBinding is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ControlTemplateBinding_H)
#define ControlTemplateBinding_H

#include <CanderaWidget/Widget2D/Widget2D.h>
#include <CanderaWidget/String/String.h>
#include "SourceItem.h"

/**
 * The ControlTemplateBinding properties can be attached to any node as dynamic properties.
 * They are used for data context index based data binding.
 */
class ControlTemplateBinding
{
   public:
      static tSharedPtrIDataItem GetDataContext(const Candera::Widget2D& widget);

#define ControlTemplateBindingInterface(bindingName) \
    static bool Is##bindingName##Bindable(const Candera::Widget2D& widget); \
    static Candera::Int32 Get##bindingName##BindingIndex(const Candera::Widget2D& widget)

#define ControlTemplateBindingInterface2(typeName, bindingName) \
    ControlTemplateBindingInterface(bindingName); \
    static typeName Get##bindingName##Value(const Candera::Widget2D& widget)

      ControlTemplateBindingInterface2(bool,            Enabled);
      ControlTemplateBindingInterface2(Candera::String, Name);
      ControlTemplateBindingInterface2(Candera::String, Text);
      ControlTemplateBindingInterface2(Candera::Int32,  Selected);
      ControlTemplateBindingInterface2(Candera::Int32,  UserData);

      ControlTemplateBindingInterface(Items);

      static void SetSelectedValue(const Candera::Widget2D& widget, Candera::Int32 value);

      static Candera::String GetErrorString();

      static Candera::String GetSourceItemAsString(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex);

      static Candera::Int32 GetSourceItemAsInteger(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex);

      static void SetSourceItemFromInteger(const tSharedPtrIDataItem& source, Candera::Int32 sourceIndex, Candera::Int32 value);

   private:
      template<typename T> static T GetSourceItem(const tSharedPtrIDataItem& source, Candera::UInt32 sourceIndex)
      {
         return gccSpecializationHelper::SourceItem<T>::Get(source, sourceIndex);
      }
};


#endif
