/* ***************************************************************************************
* FILE:          ListItemCachingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListItemCachingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ListItemCachingBehavior_H)
#define ListItemCachingBehavior_H

#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloningStrategy.h>

class ClonedItemCachingBehavior
{
   public:
      FEATSTD_TYPEDEF_SHARED_POINTER(ClonedItemCachingBehavior);

      virtual ControlTemplateCloningStrategy& GetCloningStrategy() = 0;
      virtual void OnPostItemsUpdateFinished(FeatStd::UInt32 firstVisibleIndex, FeatStd::UInt32 lastVisibleIndex) {};
      virtual void OnPostItemsUpdated(FeatStd::UInt32 firstVisibleIndex, FeatStd::UInt32 lastVisibleIndex) {};
      virtual bool OnMessage(const Courier::Message& msg) = 0;
      virtual void Update() = 0;
   private:
      FEATSTD_SHARED_POINTER_DECLARATION();
};


#endif
