/* ***************************************************************************************
* FILE:          CloneProperties.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CloneProperties is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplateCloneHelper.h"
#include "ControlTemplateBinding.h"

#include "CloneProperties.h"


#define CloneWidgetProperty(propertyName)                widgetClone.Set##propertyName( widget.Get##propertyName())
#define CloneAnimationPlayerProperty(propertyName)       animationPlayerClone.Set##propertyName( animationPlayer.Get##propertyName())
#define CloneAnimationControllerProperty(propertyName)   animationControllerClone.Set##propertyName( animationController.Get##propertyName())


void PropertiesClonners::CloneProperties(const Candera::Widget2D& widget, Candera::Widget2D& widgetClone, ControlTemplateInstance& controlTemplateInstance)
{
   CloneWidgetProperty(Name);
   CloneWidgetProperty(AnimationTimeDispatcher);

   const Candera::StringIdentifier* stringId = widget.GetStringId();
   if (0 != stringId)
   {
      ControlTemplateCloneHelper::SetWidgetStringId(controlTemplateInstance, widgetClone, stringId);
   }

   if (ControlTemplateBinding::IsNameBindable(widgetClone))
   {
      Candera::String name = ControlTemplateBinding::GetNameValue(widgetClone);
      // keep reference to string until the widgets are disposed
      ControlTemplateCloneHelper::SetWidgetName(controlTemplateInstance, widgetClone, name);
      /* * /
              if (0 != widget.GetNode())
              {
              char buf[200];
              strcpy(buf, "?");

              if (0 != widget.GetNode()->GetParent())
              {
              if (0 != widget.GetNode()->GetParent()->GetParent())
              {
              if (0 != widget.GetNode()->GetParent()->GetParent()->GetParent())
              {
              snprintf(buf, sizeof(buf), "%s/%s/%s/%s",
              widget.GetNode()->GetParent()->GetParent()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetParent()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetLegacyName());
              }
              else
              {
              snprintf(buf, sizeof(buf), "%s/%s/%s",
              widget.GetNode()->GetParent()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetLegacyName());
              }
              }
              else
              {
              snprintf(buf, sizeof(buf), "%s/%s",
              widget.GetNode()->GetParent()->GetLegacyName(),
              widget.GetNode()->GetLegacyName());
              }
              }
              else
              {
              snprintf(buf, sizeof(buf), "%s", widget.GetNode()->GetLegacyName() );
              }

              ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(),"CloneProperties:: NameBinding: Node tree = %s", buf));
              ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(),"CloneProperties:: WidgetClone.GetName = %12s, HashId = %ul",
              widgetClone.GetLegacyName(), Courier::Identifier(widgetClone.GetLegacyName()).HashValue() ));
              }
              / * */
   }
}


void PropertiesClonners::CloneProperties(const Candera::Animation::AnimationPlayer& animationPlayer, Candera::Animation::AnimationPlayer& animationPlayerClone)
{
   CloneAnimationPlayerProperty(Name);
   CloneAnimationPlayerProperty(Direction);
   CloneAnimationPlayerProperty(RepeatCount);
   CloneAnimationPlayerProperty(RepeatMode);
   CloneAnimationPlayerProperty(SequenceStartTimeMs);
   CloneAnimationPlayerProperty(SequenceDurationMs);
   CloneAnimationPlayerProperty(SpeedFactor);
}


void PropertiesClonners::CloneProperties(const Candera::Animation::AnimationController& animationController, Candera::Animation::AnimationController& animationControllerClone)
{
   CloneAnimationControllerProperty(SpeedFactor);
   CloneAnimationControllerProperty(WorldReferenceTime);
   CloneAnimationControllerProperty(SequenceReferenceTime);
}
