/* ***************************************************************************************
* FILE:          CloneCachingStrategyHelper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CloneCachingStrategyHelper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "ControlTemplate.h"
#include <Widgets/2D/ControlTemplate/CloneEvents.h>

#include "hmi_trace_if.h"
#include "Widgets/widget_etg_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LIST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CloneCachingStrategyHelper.cpp.trc.h"
#endif
#include "CloneCachingStrategyHelper.h"


void CloneCachingStrategyHelper::UpdateControlTemplateInstance(ControlTemplateInstancePtr& controlTemplateInstance, const EventHub::Event& reuseInstanceEvent, Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations)
{
   if (!controlTemplateInstance.PointsToNull())
   {
      const Candera::Node2D* originalTemplateNode = controlTemplateInstance->GetTemplateNode();
      Candera::Node2D* itemRootNode = controlTemplateInstance->GetItemRootNode();
      if ((0 != itemRootNode) && (originalTemplateNode == (&templateNode)))
      {
         Candera::Layouter::SetMargin(*itemRootNode, Candera::Margin(0, 0, 0, 0));

         tSharedPtrIDataItem oldSource(ControlTemplate::GetDataContext(*itemRootNode));
         bool sourceChanged = (source != oldSource);
         if (sourceChanged)
         {
            ControlTemplate::SetDataContext(*itemRootNode, source);
         }

         if (!source.PointsToNull())
         {
            bool updated(source->updateDataBindings(false));
            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "CloneCachingStrategyHelper::UpdateControlTemplateInstance pre ClonePropertiesInternal owner=%p, updated = %d, sourceChanged = %d", owner, updated, sourceChanged));
            if (updated || sourceChanged)
            {
               bool cloned(controlTemplateInstance->ClonePropertiesInternal());
               ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "CloneCachingStrategyHelper::UpdateControlTemplateInstance post ClonePropertiesInternal owner=%p, cloned = %d", owner, cloned));
            }
         }

         controlTemplateInstance->UpdateClonedAnimations(templateAnimations, controlTemplateInstance->GetControlTemplateMap());

         EventHub::Notify(reuseInstanceEvent);

         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "CloneCachingStrategyHelper::UpdateControlTemplateInstance reused owner=%p", owner));
      }
   }
}
