/* ***************************************************************************************
* FILE:          CloneCachingStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CloneCachingStrategy is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(CloneCachingStrategy_H)
#define CloneCachingStrategy_H

#include "Candera/Engine2D/Core/Node2D.h"
#include "DataItem.h"
#include "Widgets/2D/List/generated/ListWidget2DBase.h"
#include "Widgets/2D/BaseWidget2D.h"

/**
 * The CloneCachingStrategy will cache instances of ControlTemplateInstance.
 * Its methods should be used by the ControlTemplateCloningStrategy to signal
 * different events.
 */
class CloneCachingStrategy
{
   public:
      virtual ~CloneCachingStrategy() { }

      /**
       * Returns a cached instance based on the given parameters; null otherwise.
       */
      virtual ControlTemplateInstancePtr Retrieve(Candera::Node2D& templateNode, const tSharedPtrIDataItem& source, BaseWidget2D* owner, FeatStd::UInt32 ownerId, FeatStd::UInt32 index, const ListWidget2DBase::TemplateScrollAnimationType& templateAnimations) = 0;

      /*
       * Should be called after a clone is made.
       */
      virtual void ProcessAfterCloning(ControlTemplateInstancePtr& instance, FeatStd::UInt32 index) = 0;

      /*
       * Should be called Before the instance is disposed. Returns whether the instance should be disposed or not.
       */
      virtual bool ProcessBeforeDisposed(ControlTemplateInstance* instance) = 0;

      /*
       * Should be called before flushing the cloning strategy. The indices represent the first and last items
       * that will be flushed
       */
      virtual void ProcessBeforeFlush(FeatStd::UInt32 firstIndex, FeatStd::UInt32 lastIndex) = 0;

      /*
       * Should be called before destroying the instance.
       */
      virtual void Finalize() = 0;
};


#endif
