/* ***************************************************************************************
* FILE:          CTIAnimationsManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CTIAnimationsManager is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CTIAnimationsManager_H
#define CTIAnimationsManager_H

#include <Candera/EngineBase/Animation/AnimationController.h>
#include <Candera/EngineBase/Animation/AnimationTimeType.h>
#include <Courier/Util/Vector.h>
#include "Candera/EngineBase/Animation/AnimationPlayerListener.h"
#include "Candera/EngineBase/Animation/AnimationPlayer.h"
#include "Candera/EngineBase/Animation/AnimationGroupPlayer.h"
#include "Candera/EngineBase/Animation/AnimationTimeDispatcher.h"
#include <Widgets/2D/Common/AnimationsContainer.h>

class CTIAnimationsManagerListener
{
   public:
      virtual ~CTIAnimationsManagerListener() { }

      virtual void OnPlaybackFinished(bool /*forward*/) { }
};


/**
 * The CTIAnimationsManager is a container for all animations that have been cloned from a control template.
 */
class CTIAnimationsManager : public AnimationsContainer,
   private Candera::Animation::AnimationPlayerListener
{
   public:

      CTIAnimationsManager();

      virtual ~CTIAnimationsManager();

      /**
      * Disposes the animations of this CTIAnimationsManager.
      */
      void DisposeContent();

      /**
       * Adds the animation to this CTIAnimationsManager instance.
       */
      void AddAnimation(const Candera::Animation::AnimationController::SharedPointer& scrollAnimation);

      /**
       * Removes all the previously added animations.
       */
      void RemoveAllAnimations();

      /**
       * Stores the world time
       */
      virtual void SetWorldTime(Candera::Animation::WorldTimeType worldTime);

      /**
       * Dispatches the previously stored worldTime internally to the animation players
       */
      virtual void DispatchWorldTime();

      /**
       * Starts the contained animations
       */
      virtual bool Start(PlaybackDirection direction);

      /**
       * Returns if whether at least one of the inner animations is running
       */
      virtual bool AreRunning() const;

      virtual bool ToBegin();
      virtual bool ToEnd();

      /**
       * Registers the given listener
       */
      void SetListener(CTIAnimationsManagerListener* val)
      {
         _listener = val;
      }

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(CTIAnimationsManager);

      typedef Courier::Vector<Candera::Animation::AnimationPlayer::SharedPointer> AnimationPlayers;

      enum Status
      {
         AtStart,
         RunningForward,
         AtEnd,
         RunningBackward
      };

      Status _animationStatus;
      AnimationPlayers _animations;
      Candera::Animation::AnimationGroupPlayer::SharedPointer _groupPlayer;
      Candera::Animation::AnimationTimeDispatcher::SharedPointer _timeDispatcher;
      CTIAnimationsManagerListener* _listener;

      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, FeatStd::Int32 completedIterationsCount);

      void OnPlaybackFinished();

      void NotifyPlaybackFinished(bool forward) const;

      void DispatchToPlayers() const;
      Candera::Animation::SequenceTimeType GetDuration(Candera::Animation::AnimationController& controller) const;
};


#endif
