/* ***************************************************************************************
* FILE:          BaseClonedItemCachingBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BaseClonedItemCachingBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(BaseClonedItemCachingBehavior_H)
#define BaseClonedItemCachingBehavior_H

#include <Widgets/2D/ControlTemplate/ClonedItemCachingBehavior.h>
#include "OnRequestCloneCachingStrategy.h"
#include "Widgets/2D/Common/OwnerInfoRetriever.h"

class BaseClonedItemCachingBehavior : public ClonedItemCachingBehavior
{
   public:
      BaseClonedItemCachingBehavior(OwnerInfoRetriever& ownerRetriever, CloneCachingStrategy& mainCachingStrategy);

      FEATSTD_TYPEDEF_SHARED_POINTER(BaseClonedItemCachingBehavior);

      virtual ControlTemplateCloningStrategy& GetCloningStrategy() override;

      virtual bool OnMessage(const Courier::Message& msg) override;

      // Inherited via ClonedItemCachingBehavior
      virtual void Update() override;
   private:
      OwnerInfoRetriever& _ownerRetriever;
      OnRequestCloneCachingStrategy _cachingStrategy;
      ControlTemplateCloningStrategy _cloningStrategy;
};


#endif
