/* ***************************************************************************************
* FILE:          NodeHelper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  NodeHelper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(NodeUtils_H)
#define NodeUtils_H

#include "lint_deactivation.h"
#include <Candera/Engine2D/Core/Node2D.h>

class NodeHelper
{
   public:
      static Candera::Node2D* GetNestedParent(Candera::Node2D* node, Candera::UInt32 level);
      static Candera::Vector2 GetSize(Candera::Node2D* node, const Candera::Vector2 clientSize);
};


#endif
