/* ***************************************************************************************
* FILE:          NodeHelper.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  NodeHelper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "NodeHelper.h"
#include <Candera/Engine2D/Core/Group2D.h>
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/Layouter.h>
#else
#include <Candera/Engine2D/Layout/Layout.h>
#endif


using namespace Candera;

Candera::Node2D* NodeHelper::GetNestedParent(Candera::Node2D* node, Candera::UInt32 level)
{
   Node2D* current = node;
   while ((0 != level) && (0 != current))
   {
      --level;
      current = current->GetParent();
   }
   return current;
}


Candera::Vector2 NodeHelper::GetSize(Candera::Node2D* node, const Candera::Vector2 clientSize)
{
   Vector2 itemSize;

   if (0 != node)
   {
      Layouter* itemNodeLayouter = node->GetLayouter();
      if (itemNodeLayouter != 0)
      {
         // Some layouter requres the node to have a parrent to get it's size
         Group2D* tempParent = 0;
         if (node->GetParent() == 0)
         {
            tempParent = Group2D::Create();
            tempParent->AddChild(node);
         }

         itemNodeLayouter->Measure(*node, clientSize);
         itemSize = itemNodeLayouter->GetClientSize(*node);

         if (tempParent != 0)
         {
            tempParent->RemoveChild(node);
            FEATSTD_DELETE(tempParent);
         }
      }
   }

   return itemSize;
}
