/* ***************************************************************************************
* FILE:          ClippingDynamicPropertyHost.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ClippingDynamicPropertyHost is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(Flex_ClippingDynamicPropertyHost_h)
#define Flex_ClippingDynamicPropertyHost_h

#include <Candera/Engine2D/Core/RenderNode.h>

class ClippingDynamicPropertyHost : public Candera::DynamicProperties::DynamicPropertyHost
{
   public:
      static void SetClippingRectangle(Candera::Node2D& node, const Candera::Rectangle clippingRect);
      static void SetTouchableRectangle(Candera::Node2D& node, const Candera::Rectangle touchableRect);

      static Candera::Rectangle GetClippingRectangle(const Candera::Node2D& node);
      static Candera::Rectangle GetTouchableRectangle(const Candera::Node2D& node);

      static const Candera::DynamicProperties::DynamicPropertyHost* ParentProvider(const Candera::DynamicProperties::DynamicPropertyHost* host)
      {
         FEATSTD_UNUSED(host);
         return 0;
      }

   private:

      FEATSTD_MAKE_CLASS_STATIC(ClippingDynamicPropertyHost);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ClippingDynamicPropertyHost);

      static const Candera::Rectangle& ClippingRectangleDefault();
      static const Candera::Rectangle& TouchableRectangleDefault();

      /**
      * Dynamic property definitions.
      */
      CdaDynamicProperties(ClippingDynamicPropertyHost, Candera::DynamicProperties::DynamicPropertyHost);
      CdaDynamicProperty(ClippingRectangle, Candera::Rectangle);
      CdaDynamicPropertyDefaultValue(ClippingRectangleDefault());
      CdaDynamicPropertyDescription("The clipping rectangle of the node.")
      CdaDynamicPropertyEnd();
      CdaDynamicProperty(TouchableRectangle, Candera::Rectangle);
      CdaDynamicPropertyDefaultValue(TouchableRectangleDefault());
      CdaDynamicPropertyDescription("The touchable rectangle of the node.")
      CdaDynamicPropertyEnd();
      CdaDynamicPropertiesEnd();
};


#endif
