/* ***************************************************************************************
* FILE:          ClippingDynamicPropertyHost.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ClippingDynamicPropertyHost is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "lint_deactivation.h"
#include "ClippingDynamicPropertyHost.h"


using namespace Candera;

const Candera::Rectangle& ClippingDynamicPropertyHost::ClippingRectangleDefault()
{
   static Candera::Rectangle clippingRectangleDefault(-Math::MaxFloat() / 2, -Math::MaxFloat() / 2, Math::MaxFloat(), Math::MaxFloat());
   return clippingRectangleDefault;
}


const Candera::Rectangle& ClippingDynamicPropertyHost::TouchableRectangleDefault()
{
   static Candera::Rectangle touchableRectangleDefault(-Math::MaxFloat() / 2, -Math::MaxFloat() / 2, Math::MaxFloat(), Math::MaxFloat());
   return touchableRectangleDefault;
}


void ClippingDynamicPropertyHost::SetClippingRectangle(Candera::Node2D& node, const Candera::Rectangle clippingRect)
{
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
   static_cast<void>(node.SetValue(CdaDynamicPropertyInstance(ClippingRectangle), clippingRect));
#endif
}


void ClippingDynamicPropertyHost::SetTouchableRectangle(Candera::Node2D& node, const Candera::Rectangle touchableRect)
{
#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
   static_cast<void>(node.SetValue(CdaDynamicPropertyInstance(TouchableRectangle), touchableRect));
#endif
}


Candera::Rectangle ClippingDynamicPropertyHost::GetClippingRectangle(const Candera::Node2D& node)
{
   Candera::Rectangle clippingRectangle(ClippingRectangleDefault());

#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
   clippingRectangle = node.GetValue(CdaDynamicPropertyInstance(ClippingRectangle));
#endif

   return clippingRectangle;
}


Candera::Rectangle ClippingDynamicPropertyHost::GetTouchableRectangle(const Candera::Node2D& node)
{
   Candera::Rectangle touchableRectangle(TouchableRectangleDefault());

#if defined(CANDERA_LAYOUT_CLIPPING_ENABLED)
   touchableRectangle = node.GetValue(CdaDynamicPropertyInstance(TouchableRectangle));
#endif

   return touchableRectangle;
}
