/* ***************************************************************************************
* FILE:          ColorSwitchWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ColorSwitchWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __COLOR_SWITCH_WIDGET2D_H__
#define __COLOR_SWITCH_WIDGET2D_H__

#include <Widgets/2D/ColorSwitch/generated/ColorSwitchWidget2DBase.h>
#include <Widgets/2D/Appearance/AppearanceState.h>

namespace hmibase {
namespace widget {
namespace color {

class ColorPropertyAccessor;

/*****************************************************************************/
/*
*/
class ColorSwitchWidget2D : public ColorSwitchWidget2DBase
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ColorSwitchWidget2D, ColorSwitchWidget2DBase);

      /*****************************************************************************/
      ColorSwitchWidget2D();
      virtual ~ColorSwitchWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;
      virtual void OnBeforeNodeChanged() override;
      virtual void OnChanged(FeatStd::UInt32 propertyId) override;
      virtual void Update() override;

      /*****************************************************************************/
      /* Widget definition */
      CdaWidget2DDef(ColorSwitchWidget2D, ColorSwitchWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      const Candera::Color& GetStateColor(const hmibase::widget::appearance::AppearanceState& state) const;
      void ClearColorPropertyAccessor();
      void InitializeColorAppearance();

      ColorPropertyAccessor* _colorPropertyAccessor;
      FeatStd::UInt8 _sourceSearchCount;
      FeatStd::UInt8 _targetSearchCount;
};


}
}


}


#endif
