/* ***************************************************************************************
* FILE:          CollapseWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CollapseWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "Widgets/2D/ControlTemplate/ControlTemplateBinding.h"
#include "Widgets/2D/Common/NodeHelper.h"

#include "CollapseWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(CollapseWidget2D);

using namespace Candera;

CollapseWidget2D::CollapseWidget2D() : _invalid(true), _originalSize(-1.0F, -1.0F)
{
}


CollapseWidget2D::~CollapseWidget2D()
{
}


bool CollapseWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const CollapseWidget2D* original = CLONEABLE_WIDGET_CAST<const CollapseWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());
      SetCollapsed(original->GetCollapsed());
      _originalSize = original->_originalSize;

      if (ControlTemplateBinding::IsSelectedBindable(*this))
      {
         Candera::Int32 value = ControlTemplateBinding::GetSelectedValue(*this);
         SetCollapsed(0 != value);
      }

      cloned = true;
   }
   return cloned;
}


void CollapseWidget2D::Update()
{
   if (_invalid && (0 != GetNode()) && (0 != GetNode()->GetScene()))
   {
      Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
      if (0 != node)
      {
         bool invalidate = false;
         if (GetCollapsed())
         {
            //disable rendering and set size to (0,0)
            if (node->IsRenderingEnabled())
            {
               node->SetRenderingEnabled(false);
               invalidate = true;
            }
            if (Layouter::GetSize(*node) != Candera::Vector2(0.0F, 0.0F))
            {
               _originalSize = Layouter::GetSize(*node);
               Layouter::SetSize(*node, Candera::Vector2(0.0F, 0.0F));
               InvalidateLayout();
               invalidate = true;
            }
         }
         else
         {
            if (!node->IsRenderingEnabled())
            {
               node->SetRenderingEnabled(true);
               invalidate = true;
            }
            if (Layouter::GetSize(*node) != _originalSize)
            {
               Layouter::SetSize(*node, _originalSize);
               InvalidateLayout();
               invalidate = true;
            }
         }
         if (invalidate)
         {
            Invalidate();
         }
      }
      _invalid = false;
   }
}


void CollapseWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   _invalid = true;
}


void CollapseWidget2D::OnNodeChanged()
{
   Base::OnNodeChanged();

   _invalid = true;
   triggerUpdate();
}
