/* ***************************************************************************************
* FILE:          ClockWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Label Widget as part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(CLOCK_WIDGET_2D_H)
#define CLOCK_WIDGET_2D_H

#include "Widgets/2D/Clock/generated/ClockWidget2DBase.h"

class ClockWidget2D : public ClockWidget2DBase
{
   public:
      ClockWidget2D();
      virtual ~ClockWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ClockWidget2D, ClockWidget2DBase);

      virtual void InitWidget(); // override
      virtual void Update(); // override
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      CdaWidget2DDef(ClockWidget2D, ClockWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(::Candera::UInt32 propertyId); // override

   private:
      class ClockItemData
      {
         public:
            ClockItemData() : _timeIsInvalid(true), _needsBmpUpload(true), _value(0), _index(0), _angle(0.0)
            {
            }
            ~ClockItemData()
            {
            }
            bool setImage(const Candera::RenderNode* pRenderNode, Candera::AssetProvider* assetProvider);
            void update(Candera::AssetProvider* assetProvider, unsigned base, Candera::RenderNode* node, const std::string& imgPath, const Candera::String& imgName, bool isFace = false);
            void clear()
            {
               _timeIsInvalid = true;
               _needsBmpUpload = true;
            }
            bool isInvalid() const
            {
               return (_timeIsInvalid || _needsBmpUpload);
            }
            bool                 _timeIsInvalid;
            bool                 _needsBmpUpload;
            Candera::UInt8       _value;
            Candera::UInt8       _index;
            Candera::Float       _angle;
            std::string          _canderaBmpName;
      };

      ClockItemData _clockFace;
      ClockItemData _hourHand;
      ClockItemData _minHand;
      ClockItemData _secHand;

      bool          _nodeIsInvalid;
      Candera::RenderNode* _rnode[4];
      std::string          _imagePath;

      void setRenderNodes(Candera::Node2D* node, unsigned int& i);
      void setImagePath();
};


#endif  // CLOCK_WIDGET_2D_H
