/* ***************************************************************************************
* FILE:          CameraControlWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CameraControlWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CameraControl_WIDGET2D_H
#define CameraControl_WIDGET2D_H

#include <bitset>
#include <Widgets/2D/CameraControl/generated/CameraControlWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>

/* ***************************************************************************************
* Provides control over a 2D node allowing to change its properties by using data binding sources or to expose them outside composites.
* There is no internal storage in the widget for the property values, they are set/retrieved directly on/from the node.
*************************************************************************************** */
class CameraControlWidget2D : public CameraControlWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(CameraControlWidget2D, CameraControlWidget2DBase);

      CameraControlWidget2D();
      virtual ~CameraControlWidget2D();

      virtual void OnChanged(::FeatStd::UInt32 propertyId);
      virtual void Update();
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:
      CdaWidget2DDef(CameraControlWidget2D, CameraControlWidget2DBase)
      CdaProperties()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      bool _viewportChanged;
};


#endif
