/* ***************************************************************************************
* FILE:          ButtonTextScrollWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonTextScrollWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ButtonTextScrollWidget2D.h"
#include "Widgets/2D/Button/ButtonWidget2D.h"
#include "Widgets/2D/Text/TextWidget2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BUTTON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ButtonTextScrollWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ButtonTextScrollWidget2D);

ButtonTextScrollWidget2D::ButtonTextScrollWidget2D() : Base()
{
}


ButtonTextScrollWidget2D::~ButtonTextScrollWidget2D()
{
}


void ButtonTextScrollWidget2D::OnChanged(::FeatStd::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   switch (propertyId)
   {
      case ScrollOnFocusGainPropertyId:
         SetInvalid(true);
         break;

      default:
         break;
   }
}


bool ButtonTextScrollWidget2D::OnMessage(const Courier::Message& msg)
{
   bool consumed = false;
   if (FocusChangedUpdMsg::ID == msg.GetId())
   {
      ButtonWidget2D* buttonWidget = GetButtonWidget();
      TextWidget2D* textWidget = GetTextWidget();
      const FocusChangedUpdMsg* focusUpdateMsg = Courier::message_cast<const FocusChangedUpdMsg*>(&msg);
      if ((focusUpdateMsg != NULL) && (buttonWidget != NULL) && (textWidget != NULL) && (GetScrollOnFocusGain()))
      {
         if (buttonWidget->IsFocused()
               && (buttonWidget->GetParentView() != NULL)
               && (buttonWidget->GetParentView()->GetId() == focusUpdateMsg->GetView())
               && (focusUpdateMsg->GetWidget() != Courier::Identifier())
               && (Courier::Identifier(buttonWidget->GetLegacyName()) == focusUpdateMsg->GetWidget()))
         {
            textWidget->startScroll();
         }
         else
         {
            textWidget->stopScroll();
         }
      }
   }
   return consumed;
}


bool ButtonTextScrollWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ButtonTextScrollWidget2D* original = CLONEABLE_WIDGET_CAST<const ButtonTextScrollWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetScrollOnFocusGain(original->GetScrollOnFocusGain());

      cloned = true;
   }
   return cloned;
}


void ButtonTextScrollWidget2D::Update()
{
   Base::Update();

   //ButtonWidget2D* buttonWidget = GetButtonWidget();
   //TextWidget2D* textWidget = GetTextWidget();
   //if (IsInvalid() && (textWidget != NULL) && (buttonWidget != NULL))
   //{
   //   SetInvalid(false);
   //}
}
