/* ***************************************************************************************
* FILE:          ButtonImageWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonImageWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ButtonImage_WIDGET2D_H
#define ButtonImage_WIDGET2D_H

#include "Widgets/2D/ButtonImage/generated/ButtonImageWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/EffectControl/ColorEffectWidget2D.h"

class ButtonWidget2D;

class ButtonImageWidget2D : public ButtonImageWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ButtonImageWidget2D, ButtonImageWidget2DBase);

      ButtonImageWidget2D();
      virtual ~ButtonImageWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual hmibase::widget::appearance::AppearanceTemplate* CreateAppearanceTemplate();

      DefProperty_ColorEffect_Color()

   private:
      virtual void Update();
      virtual void OnChanged(::FeatStd::UInt32 propertyId);

      Candera::MemoryManagement::SharedPointer<Candera::Image2D> GetButtonStateBitmap() const;

      CdaWidget2DDef(ButtonImageWidget2D, ButtonImageWidget2DBase)
      CdaProperties()

      CdaProperty_ColorEffect_Color()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
