/* ***************************************************************************************
 * FILE:          ButtonGroupWidget2D.cpp
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ButtonGroupWidget2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#include "widget2D_std_if.h"
#include "ButtonGroupWidget2D.h"
#include "ButtonGroupController2D.h"
#include <Widgets/2D/ControlTemplate/ControlTemplateBinding.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BUTTON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ButtonGroupWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ButtonGroupWidget2D)

/*****************************************************************************/
ButtonGroupWidget2D::ButtonGroupWidget2D() : Base()
{
   SetTouchable(false);
}


/*****************************************************************************/
ButtonGroupWidget2D::~ButtonGroupWidget2D()
{
}


/*****************************************************************************/
bool ButtonGroupWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ButtonGroupWidget2D* original = CLONEABLE_WIDGET_CAST<const ButtonGroupWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      if (ControlTemplateBinding::IsSelectedBindable(*this))
      {
         SetActiveIndex(ControlTemplateBinding::GetSelectedValue(*this));
      }
      else
      {
         SetActiveIndex(original->GetActiveIndex());
      }

      SetAdornerContainerNode(controlTemplateMap.ResolveNodeClone(original->GetAdornerContainerNode()));
      SetAnimationEnabled(original->GetAnimationEnabled());
      SetAnimationDuration(original->GetAnimationDuration());

      cloned = true;
   }
   return cloned;
}


/*****************************************************************************/
hmibase::widget::WidgetController* ButtonGroupWidget2D::GetDefaultController() const
{
   return &(DefaultButtonGroupController2D::getInstance());
}


/*****************************************************************************/
bool ButtonGroupWidget2D::findButtons(std::vector<ButtonWidget2D*>& buttons)
{
   ButtonGroupController2D* controller = Candera::Dynamic_Cast<ButtonGroupController2D*>(GetController());
   return (controller != NULL) && controller->findButtons(*this, buttons);
}
