/* ***************************************************************************************
* FILE:          ButtonAnimationWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonAnimationWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ButtonAnimation_WIDGET2D_H
#define ButtonAnimation_WIDGET2D_H

#include "Widgets/2D/ButtonAnimation/generated/ButtonAnimationWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/Button/ButtonExtensionWidget2D.h"

class ButtonAnimationWidget2D : public ButtonAnimationWidget2DBase, public ButtonExtension
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ButtonAnimationWidget2D, ButtonAnimationWidget2DBase);

      ButtonAnimationWidget2D();
      virtual ~ButtonAnimationWidget2D();

      /////////////////////////////////////////////////////////////////////////

      // overrides from Candera::Widget
      virtual void Update();
      virtual void OnNodeChanged();
      virtual void OnParentViewActivate(bool activate);

      // overrides from ControlTemplateCloneableWidget
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      /////////////////////////////////////////////////////////////////////////
      // Widget definition
      CdaWidget2DDef(ButtonAnimationWidget2D, ButtonAnimationWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
      /////////////////////////////////////////////////////////////////////////

   private:
      bool _isCurrentStateValid;
      AppearanceState _currentState;
};


#endif
