/* ***************************************************************************************
* FILE:          ButtonAnimationWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonAnimationWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ButtonAnimationWidget2D.h"
#include <Widgets/2D/Button/ButtonWidget2D.h>

#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BUTTONANIMATION
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ButtonAnimationWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ButtonAnimationWidget2D);


ButtonAnimationWidget2D::ButtonAnimationWidget2D() : Base(), _isCurrentStateValid(false)
{
   SetShouldRun(false);
}


ButtonAnimationWidget2D::~ButtonAnimationWidget2D()
{
}


bool ButtonAnimationWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned = false;
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ButtonAnimationWidget2D* original = CLONEABLE_WIDGET_CAST<const ButtonAnimationWidget2D*>(originalWidget);
      if (original != NULL)
      {
         SetOnDisable(original->GetOnDisable());
         SetOnEnable(original->GetOnEnable());
         SetOnRelease(original->GetOnRelease());
         SetOnPress(original->GetOnPress());
         SetOnDeactivate(original->GetOnDeactivate());
         SetOnActivate(original->GetOnActivate());
         SetOnLoseFocus(original->GetOnLoseFocus());
         SetOnFocus(original->GetOnFocus());

         SetReverseOnDisable(original->GetReverseOnDisable());
         SetReverseOnEnable(original->GetReverseOnEnable());
         SetReverseOnRelease(original->GetReverseOnRelease());
         SetReverseOnPress(original->GetReverseOnPress());
         SetReverseOnDeactivate(original->GetReverseOnDeactivate());
         SetReverseOnActivate(original->GetReverseOnActivate());
         SetReverseOnLoseFocus(original->GetReverseOnLoseFocus());
         SetReverseOnFocus(original->GetReverseOnFocus());

         SetCheckEnabled(original->GetCheckEnabled());
         SetCheckPressed(original->GetCheckPressed());
         SetCheckActive(original->GetCheckActive());
         SetCheckFocused(original->GetCheckFocused());

         SetIsEnabled(original->GetIsEnabled());
         SetIsPressed(original->GetIsPressed());
         SetIsActive(original->GetIsActive());
         SetIsFocused(original->GetIsFocused());

         //don't take any state info from the template, this extension widget has its own button
         //_isCurrentStateValid = original->_isCurrentStateValid;
         //_currentState = original->_currentState;

         cloned = true;
      }
   }
   return cloned;
}


void ButtonAnimationWidget2D::Update()
{
   Base::Update();
   ButtonExtension::Update(*this);

   ButtonWidget2D* button = GetButtonWidget();
   if (button != NULL)
   {
      const AppearanceState state = GetButtonState();

      ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Update state=%d currentState=%d stateValid=%u button=%50s %s",
                          ETG_CENUM(hmibase::widget::appearance::AppearanceState::ENUM, state.asEnum()),
                          ETG_CENUM(hmibase::widget::appearance::AppearanceState::ENUM, _currentState.asEnum()),
                          _isCurrentStateValid,
                          HMIBASE_TO_STRING_W(button),
                          HMIBASE_TO_STRING_VW(this)));

      if (_isCurrentStateValid)
      {
         //at least one trigger should be enabled for the animation to start
         bool trigger = false;
         bool reverse = false;

         if (GetOnDisable() && !state.isEnabled() && _currentState.isEnabled())
         {
            trigger = true;
            reverse = GetReverseOnDisable();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnDisable reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnEnable() && state.isEnabled() && !_currentState.isEnabled())
         {
            trigger = true;
            reverse = GetReverseOnEnable();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnEnable reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnRelease() && !state.isPressed() && _currentState.isPressed())
         {
            trigger = true;
            reverse = GetReverseOnRelease();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnRelease reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnPress() && state.isPressed() && !_currentState.isPressed())
         {
            trigger = true;
            reverse = GetReverseOnPress();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnPress reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnDeactivate() && !state.isActive() && _currentState.isActive())
         {
            trigger = true;
            reverse = GetReverseOnDeactivate();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnDeactivate reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnActivate() && state.isActive() && !_currentState.isActive())
         {
            trigger = true;
            reverse = GetReverseOnActivate();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnActivate reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnLoseFocus() && !state.isFocused() && _currentState.isFocused())
         {
            trigger = true;
            reverse = GetReverseOnLoseFocus();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnLoseFocus reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else if (GetOnFocus() && state.isFocused() && !_currentState.isFocused())
         {
            trigger = true;
            reverse = GetReverseOnFocus();

            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update OnFocus reverse=%u button=%50s %s",
                                reverse, HMIBASE_TO_STRING_W(button), HMIBASE_TO_STRING_VW(this)));
         }
         else
         {
            //no trigger
         }

         //all enabled guards should match the state
         bool guard = true;
         guard = guard && (!IsEnabledValueVisible() || (GetIsEnabled() && state.isEnabled()));
         guard = guard && (!IsPressedValueVisible() || (GetIsPressed() && state.isPressed()));
         guard = guard && (!IsActiveValueVisible() || (GetIsActive() && state.isActive()));
         guard = guard && (!IsFocusedValueVisible() || (GetIsFocused() && state.isFocused()));

         if (trigger && guard)
         {
            stopAnimation();  // Stop the animation if playing
            if (!_animationPlayer.PointsToNull())
            {
               _animationPlayer->SetDirection(reverse ? Candera::Animation::AnimationPlayer::Reverse : Candera::Animation::AnimationPlayer::Forward);
            }
            startAnimation();
         }
      }

      _currentState = state;
      _isCurrentStateValid = true;
   }
}


void ButtonAnimationWidget2D::OnNodeChanged()
{
   Base::OnNodeChanged();
   ButtonExtension::OnNodeChanged(GetNode());
   _isCurrentStateValid = false;
}


void ButtonAnimationWidget2D::OnParentViewActivate(bool activate)
{
   SetShouldRun(false);
   Base::OnParentViewActivate(activate);
   _isCurrentStateValid = false;
}
