/* ***************************************************************************************
 * FILE:          ButtonAppearance2D.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ButtonAppearance2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#if !defined(hmibase_Button_Appearance2D_h)
#define hmibase_Button_Appearance2D_h

#include <CanderaAssetLoader/AssetLoaderBase/AssetLibEntities.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetIdMacros.h>
#include <Widgets/2D/Appearance/AppearanceState.h>
#include <Widgets/2D/Appearance/Appearance2D.h>


class ButtonWidget2D;
class ButtonExtensionWidget2D;


namespace hmibase {
namespace widget {
namespace appearance {


/**************************************************************************/
/* Button Image Id */
/**************************************************************************/
#define _HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID _HMIBASE_APPEARANCE_IMAGE_ASSET_ID
#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_DATA HMIBASE_APPEARANCE_ASSET_ID_DATA
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID HMIBASE_APPEARANCE_IMAGE_ASSET_ID


/**************************************************************************/
/* Pressed */
#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_PREFIX_DATA_P HMIBASE_APPEARANCE_ASSET_ID_PREFIX_DATA_P
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID_PREFIX_P HMIBASE_APPEARANCE_IMAGE_ASSET_ID_PREFIX_P


/**************************************************************************/
/* Pressed, Disabled */
#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_PREFIX_DATA_PD HMIBASE_APPEARANCE_ASSET_ID_PREFIX_DATA_PD
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID_PREFIX_PD HMIBASE_APPEARANCE_IMAGE_ASSET_ID_PREFIX_PD

/**************************************************************************/
/* Pressed, Disabled, Active */
#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_PREFIX_DATA_PDA HMIBASE_APPEARANCE_ASSET_ID_PREFIX_DATA_PDA
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID_PREFIX_PDA HMIBASE_APPEARANCE_IMAGE_ASSET_ID_PREFIX_PDA


/**************************************************************************/
/* Pressed, Disabled, Active, Focused */
#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_PREFIX_DATA_PDAF HMIBASE_APPEARANCE_ASSET_ID_PREFIX_DATA_PDAF
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID_PREFIX_PDAF HMIBASE_APPEARANCE_IMAGE_ASSET_ID_PREFIX_PDAF


#define HMIBASE_APPEARANCE_BUTTON_ASSET_ID_BITMASK_PREFIX_DATA HMIBASE_APPEARANCE_ASSET_ID_BITMASK_PREFIX_DATA
#define HMIBASE_APPEARANCE_BUTTON_IMAGE_ASSET_ID_BITMASK_PREFIX HMIBASE_APPEARANCE_IMAGE_ASSET_ID_BITMASK_PREFIX

/**************************************************************************/
/* Button Color */
/**************************************************************************/
#define HMIBASE_APPEARANCE_BUTTON_COLOR HMIBASE_APPEARANCE_COLOR

/**************************************************************************/
/* Pressed */
#define _HMIBASE_APPEARANCE_NEW_BUTTON_COLOR_DATA_P _HMIBASE_APPEARANCE_NEW_COLOR_DATA_P
#define HMIBASE_APPEARANCE_BUTTON_COLOR_DATA_P HMIBASE_APPEARANCE_COLOR_DATA_P
#define HMIBASE_APPEARANCE_BUTTON_COLOR_P HMIBASE_APPEARANCE_COLOR_P

/**************************************************************************/
/* Pressed, Disabled */
#define _HMIBASE_APPEARANCE_NEW_BUTTON_COLOR_DATA_PD _HMIBASE_APPEARANCE_NEW_COLOR_DATA_PD
#define HMIBASE_APPEARANCE_BUTTON_COLOR_DATA_PD HMIBASE_APPEARANCE_COLOR_DATA_PD
#define HMIBASE_APPEARANCE_BUTTON_COLOR_PD HMIBASE_APPEARANCE_COLOR_PD


/**************************************************************************/
/* Pressed, Disabled, Active */
#define _HMIBASE_APPEARANCE_NEW_BUTTON_COLOR_DATA_PDA _HMIBASE_APPEARANCE_NEW_COLOR_DATA_PDA
#define HMIBASE_APPEARANCE_BUTTON_COLOR_DATA_PDA HMIBASE_APPEARANCE_COLOR_DATA_PDA
#define HMIBASE_APPEARANCE_BUTTON_COLOR_PDA HMIBASE_APPEARANCE_COLOR_PDA


/**************************************************************************/
/* Pressed, Disabled, Active, Focused */
#define _HMIBASE_APPEARANCE_NEW_BUTTON_COLOR_DATA_PDAF _HMIBASE_APPEARANCE_NEW_COLOR_DATA_PDAF
#define HMIBASE_APPEARANCE_BUTTON_COLOR_DATA_PDAF HMIBASE_APPEARANCE_COLOR_DATA_PDAF
#define HMIBASE_APPEARANCE_BUTTON_COLOR_PDAF HMIBASE_APPEARANCE_COLOR_PDAF


/**************************************************************************/
/**************************************************************************/


/**************************************************************************/
class ButtonAppearanceHelper
{
   public:
      static bool registerExtensionAppearanceTemplate(ButtonWidget2D& button, ButtonExtensionWidget2D& extension);

   private:
      FEATSTD_MAKE_CLASS_STATIC(ButtonAppearanceHelper);
};


}
}


}


#endif // hmibase_Button_Appearance2D_h
