/* ***************************************************************************************
* FILE:          Scale2DPropertySetter.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Scale2DPropertySetter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Scale2DPropertySetter.h"
#include "Candera/Engine2D/Core/Transformable2D.h"

namespace Candera {

namespace Animation {

CANDERA_RTTI_DEFINITION(Scale2DPropertySetter)

/******************************************************************************
     *  Scale2DPropertySetter::Set
     ******************************************************************************/
void Scale2DPropertySetter::Set(const Float* value)
{
   Transformable2D* transformable = GetTransformable();
   if (transformable != 0)
   {
      transformable->SetScale(value[0], value[0]);
   }
}


}
}
