/* ***************************************************************************************
* FILE:          BlurViewScene2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurViewScene2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidget2DSpace_BlurViewScene2D_h__
#define BlurWidget2DSpace_BlurViewScene2D_h__

#include "Widgets/utils/Blur/BlurTypes.h"

#ifdef COURIER_ENHANCED_ENABLED
#include "View/CGI/CgiExtensions/ViewScene2D.h"

namespace hmibase {
namespace widget {
namespace blur {

class BlurWidget2D;

class BlurViewScene2D : public hmibase::view::ViewScene2D
{
      typedef hmibase::view::ViewScene2D Base;
      typedef std::vector<BlurWidget2D*> BlurWidgetVector;
   public:
      BlurViewScene2D(bool managed = false);
      virtual ~BlurViewScene2D();

      virtual void Finalize();

      virtual bool IsUseDirtyAreaEnabled();

      virtual bool IsBlurEnabled();

      // Reimplementations of base class functions
      virtual bool DistributeMessage(const Courier::Message& msg);
      virtual void Update(Courier::RenderHint* renderHint);
      virtual void Invalidate(Courier::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea);
      virtual void Invalidate(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::Camera2D* camera, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::Camera2D* camera, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::RenderTarget* renderTarget, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

      void AddBlurWidget(BlurWidget2D* blurWidget);
      void RemoveBlurWidget(BlurWidget2D* blurWidget);

   private:
      BlurWidgetVector m_blurWidgets;
      FeatStd::Int m_maximalBlurRadius;

      void RetrieveMaximalBlurRadius();

      void DeleteWidgetRenderJobs(Candera::Camera2D* camera, BlurWidget2D* widget, Courier::Renderer* renderer);
      void DeleteBlurRenderJobs(BlurWidget2D* widget, Courier::Renderer* renderer);

      void InvalidateWidget(Candera::Camera2D* camera, BlurWidget2D* widget, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, Courier::Renderer* renderer);
      void InvalidateCamera(Candera::Camera2D* camera, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, Courier::Renderer* renderer);
};


}   /* hmibase */
}   /* widget */
}   /* blur */

#endif  // BlurViewScene2D_h__
#endif
