/* ***************************************************************************************
* FILE:          AnimationControlWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationControlWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(AnimationControlWidget2D_H)
#define AnimationControlWidget2D_H

#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include <Candera/EngineBase/Animation/AnimationPlayerListener.h>
#include <Widgets/2D/AnimationControl/generated/AnimationControlWidget2DBase.h>
#include <View/CGI/CgiExtensions/AnimationWrapper.h>

namespace hmibase {
namespace widget {
namespace animation {

class AnimationControlWidget2D : public AnimationControlWidget2DBase, protected Candera::Animation::AnimationPlayerListener
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(AnimationControlWidget2D, AnimationControlWidget2DBase);

      AnimationControlWidget2D();
      virtual ~AnimationControlWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();
      virtual void Finalize();

      virtual void OnParentViewRenderingEnabled(bool enable);
      virtual void OnParentViewActivate(bool activate);
      virtual void OnParentViewLoad(bool load);

      CdaWidget2DDef(AnimationControlWidget2D, AnimationControlWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, FeatStd::Int32 completedIterationsCount);
      virtual void OnStartAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnStopAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnFinishAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnResumeAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnPauseAnimation(Candera::Animation::AnimationPlayerBase* animationPlayer);
      virtual void OnDirectionChange(Candera::Animation::AnimationPlayerBase* animationPlayer, FeatStd::Int direction);

      virtual void OnChanged(FeatStd::UInt32 propertyId);

      virtual bool prepareAnimation();
      virtual Candera::Animation::AnimationPropertySetter::SharedPointer createPropertySetter(size_t& channelCount, FeatStd::Float* currentValue);
      virtual Courier::AnimationProperties getAnimationProperties();

      bool _invalid;
      ::hmibase::view::AnimationWrapper _animationWrapper;
      ::hmibase::view::AnimatedPropertyWrapper _animatedPropertyWrapper;
};


}
}


}

#endif
