/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/videobuffer/VideoBuffer.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/VideoBuffer.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace videobuffer {

VideoBuffer::VideoBuffer(uint16_t width, uint16_t height, uint16_t depth, uint16_t bpp)
   : mWidth(width)
   , mHeight(height)
   , mDepth(depth)
   , mBpp(bpp)
{
}


VideoBuffer::~VideoBuffer()
{
}


uint16_t VideoBuffer::getWidth() const
{
   return mWidth;
}


uint16_t VideoBuffer::getHeight() const
{
   return mHeight;
}


uint16_t VideoBuffer::getDepth() const
{
   return mDepth;
}


uint16_t VideoBuffer::getBpp() const
{
   return mBpp;
}


uint32_t VideoBuffer::getPitch() const
{
   return mWidth * mBpp;
}


int32_t VideoBuffer::getFd() const
{
   return -1;
}


} // namespace
} // namespace
} // namespace
