/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/videobuffer/DummyBuffer.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/DummyBuffer.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace videobuffer {

DummyBuffer::DummyBuffer(uint16_t width, uint16_t height, uint16_t depth, uint16_t bpp)
   : VideoBuffer(width, height, depth, bpp)
{
}


DummyBuffer::~DummyBuffer()
{
}


int32_t DummyBuffer::create()
{
   return -1;
}


void DummyBuffer::attach(int32_t /*id*/, uint32_t /*size*/, uint32_t /*pitch*/)
{
}


uint8_t* DummyBuffer::getDataPtr() const
{
   return NULL;
}


uint32_t DummyBuffer::getDataSize() const
{
   return 0;
}


} // namespace
} // namespace
} // namespace
