/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/TypeCountable.h"
#include "hmibase/util/TypeCounter.h"
#include "hmibase/util/Singleton.h"
#include <typeinfo>


namespace hmibase {
namespace util {

TypeCountable::TypeCountable()
{
   TypeCounter& typeCounter = Singleton<TypeCounter>::getInstance();
   typeCounter.registerObject(this);
}


TypeCountable::~TypeCountable()
{
   TypeCounter& typeCounter = Singleton<TypeCounter>::getInstance();
   typeCounter.releaseObject(this);
}


SimpleString TypeCountable::getTypeName() const
{
   return SimpleString(typeid(*this).name());
}


int TypeCountable::getTypeCount()
{
   TypeCounter& typeCounter = Singleton<TypeCounter>::getInstance();
   return typeCounter.getTypeCount(getTypeName());
}


} // namespace
} // namespace
