/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/Timeout.h"
#include <time.h>

namespace hmibase {
namespace util {

Timeout::Timeout(unsigned int milliseconds)
{
   mEnd = getCurrentMilliseconds() + milliseconds;
}


Timeout::~Timeout()
{
}


bool Timeout::isReached() const
{
   return getCurrentMilliseconds() >= mEnd;
}


unsigned long long Timeout::getCurrentMilliseconds() const
{
   timespec timeSpec;
   clock_gettime(CLOCK_MONOTONIC, &timeSpec);

   unsigned long long milliseconds = 0;
   milliseconds += ((unsigned long long)(timeSpec.tv_sec)) * 1000;
   milliseconds += ((unsigned long long)(timeSpec.tv_nsec)) / 1000000;
   return milliseconds;
}


} // namespace
} // namespace
