/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/SimpleThread.h"
#include "hmibase/util/SimpleThreadImpl.h"

#ifdef WIN32
#include "hmibase/util/SimpleThreadImplWindows.h"
#else
#include "hmibase/util/SimpleThreadImplPosix.h"
#endif

#include "hmibase/util/Trace.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SimpleThread.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace util {

SimpleThread::SimpleThread(Threadable& threadable, const SimpleString& name)
   : mImplPtr(NULL)
{
#ifdef WIN32
   mImplPtr = new SimpleThreadImplWindows(threadable, name);
#else
   mImplPtr = new SimpleThreadImplPosix(threadable, name);
#endif
}


SimpleThread::~SimpleThread()
{
   if (mImplPtr != NULL)
   {
      delete mImplPtr;
      mImplPtr = NULL;
   }
   else
   {
      ETG_TRACE_FATAL_THR(("SimpleThread::~SimpleThread(): mImplPtr == NULL"));
   }
}


void SimpleThread::start()
{
   if (mImplPtr != NULL)
   {
      mImplPtr->start();
   }
   else
   {
      ETG_TRACE_FATAL_THR(("SimpleThread::start(): mImplPtr == NULL"));
   }
}


void SimpleThread::finish()
{
   if (mImplPtr != NULL)
   {
      mImplPtr->finish();
   }
   else
   {
      ETG_TRACE_FATAL_THR(("SimpleThread::finish(): mImplPtr == NULL"));
   }
}


bool SimpleThread::isRunning()
{
   if (mImplPtr != NULL)
   {
      return mImplPtr->isRunning();
   }
   else
   {
      ETG_TRACE_FATAL_THR(("SimpleThread::isRunning(): mImplPtr == NULL"));
      return false;
   }
}


void SimpleThread::sleep(unsigned int milliseconds)
{
   if (mImplPtr != NULL)
   {
      mImplPtr->sleep(milliseconds);
   }
   else
   {
      ETG_TRACE_FATAL_THR(("SimpleThread::sleep(): mImplPtr == NULL"));
   }
}


} // namespace
} // namespace
