/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifdef WIN32

#include "hmibase/util/Path.h"
#include <windows.h>


namespace hmibase {
namespace util {


bool Path::isFile() const
{
   switch (GetFileAttributesA(toString().cPtr()))
   {
      case INVALID_FILE_ATTRIBUTES:
         return false;
      case FILE_ATTRIBUTE_DIRECTORY:
         return false;
      default:
         return true;
   }
}


bool Path::isDirectory() const
{
   switch (GetFileAttributesA(toString().cPtr()))
   {
      case INVALID_FILE_ATTRIBUTES:
         return false;
      case FILE_ATTRIBUTE_DIRECTORY:
         return true;
      default:
         return false;
   }
}


bool Path::exists() const
{
   switch (GetFileAttributesA(toString().cPtr()))
   {
      case INVALID_FILE_ATTRIBUTES:
         return false;
      case FILE_ATTRIBUTE_DIRECTORY:
         return true;
      default:
         return true;
   }
}


std::set<Path> Path::getChildren() const
{
   std::set<Path> paths;

   HANDLE hFind = INVALID_HANDLE_VALUE;
   WIN32_FIND_DATA findData;

   hFind = FindFirstFile(toString().cPtr(), &findData);
   if (hFind != INVALID_HANDLE_VALUE)
   {
      do
      {
         SimpleString elementName(findData.cFileName);

         if (elementName != ""
               && elementName != "."
               && elementName != "..")
         {
            Path path = *this;
            path += elementName;
            paths.insert(path);
         }
      }
      while (FindNextFile(hFind, &findData) != 0);

      FindClose(hFind);
   }

   return paths;
}


} // namespace
} // namespace

#endif // WIN32
