/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_UTIL_MEMORYINFOIMPLPOSIX_H
#define HMIBASE_UTIL_MEMORYINFOIMPLPOSIX_H
#ifndef WIN32

#include "hmibase/util/MemoryInfoImpl.h"
#include <sys/sysinfo.h>

namespace hmibase {
namespace util {


class MemoryInfoImplPosix : public MemoryInfoImpl
{
   public:
      MemoryInfoImplPosix();
      virtual ~MemoryInfoImplPosix();

      virtual void refresh();

      virtual unsigned long long getTotalMemory() const;
      virtual unsigned long long getTotalUsedMemory() const;
      virtual unsigned long long getProcessUsedMemory() const;

   private:
      struct sysinfo mSysInfo;
      unsigned long long mProcessUsedBytes;

      void readSysInfo();
      void readProcSelf();
};


} // namespace
} // namespace
#endif // !WIN32
#endif
