/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/MemoryInfo.h"

#ifdef WIN32
#include "hmibase/util/MemoryInfoImplWindows.h"
#else
#include "hmibase/util/MemoryInfoImplPosix.h"
#endif

#include "hmibase/util/Trace.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MemoryInfo.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


namespace hmibase {
namespace util {


MemoryInfo::MemoryInfo()
   : mImplPtr(NULL)
{
#ifdef WIN32
   mImplPtr = new MemoryInfoImplWindows();
#else
   mImplPtr = new MemoryInfoImplPosix();
#endif
}


MemoryInfo::~MemoryInfo()
{
   if (mImplPtr != NULL)
   {
      delete mImplPtr;
      mImplPtr = NULL;
   }
}


void MemoryInfo::refresh()
{
   mImplPtr->refresh();
}


unsigned long long MemoryInfo::calcUnits(unsigned long long bytes, Unit unit) const
{
   unsigned long long result = 0;
   switch (unit)
   {
      case BYTE:
         result = bytes;
         break;
      case KILO_BYTE:
         result = bytes >> 10;
         break;
      case MEGA_BYTE:
         result = bytes >> 20;
         break;
      case GIGA_BYTE:
         result = bytes >> 30;
         break;
      default:
         ETG_TRACE_FATAL_THR(("MemoryInfo::calcUnits(): Unknown unit type: %d", unit));
         break;
   }
   return result;
}


unsigned long long MemoryInfo::getTotalMemory(Unit unit) const
{
   unsigned long long bytes = mImplPtr->getTotalMemory();
   unsigned long long units = calcUnits(bytes, unit);
   return units;
}


unsigned long long MemoryInfo::getTotalUsedMemory(Unit unit) const
{
   unsigned long long bytes = mImplPtr->getTotalUsedMemory();
   unsigned long long units = calcUnits(bytes, unit);
   return units;
}


unsigned long long MemoryInfo::getProcessUsedMemory(Unit unit) const
{
   unsigned long long bytes = mImplPtr->getProcessUsedMemory();
   unsigned long long units = calcUnits(bytes, unit);
   return units;
}


} // namespace
} // namespace
