/* ***************************************************************************************
* FILE:          FramedStream.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FramedStream.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hmibase/util/FramedStream.h"
#include "hmibase/util/Trace.h"
#include <string.h>

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FramedStream.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


namespace hmibase {
namespace util {

// Frame Escape Codes
#define FR_ESC    0xF0      // next char is a command
#define TR_START  0xF1      // packet start
#define TR_END    0xF2      // packet stop
#define TR_ESC    0xF3      // escape-char self

FramedStream::FramedStream() : _fktPack(0)
{
}


FramedStream::~FramedStream()
{
}


FramedStream::FramedStream(FramedStream::IFramedStreamCallback* fktPack) : _fktPack(fktPack)
{
}


void FramedStream::addIncommingData(unsigned char* recvbuf, int l)
{
   for (int i = 0; i < l; i++)
   {
      if (_packbuf._esc)
      {
         _packbuf._esc = 0;
         if (recvbuf[i] == TR_START)
         {
            _packbuf._cnt = 0;
            continue;
         }
         if (recvbuf[i] == TR_END)
         {
            if (_fktPack)
            {
               _fktPack->onPacketReceived(_packbuf._buf, _packbuf._cnt);
            }
            _packbuf._cnt = 0;
            continue;
         }
         if (recvbuf[i] == TR_ESC)
         {
            if (_packbuf._cnt < _packbuf._len)
            {
               _packbuf._buf[_packbuf._cnt++] = FR_ESC;
            }
            continue;
         }
         ETG_TRACE_ERR_THR(("FramedStream-ERROR: Invalid esc sequence ..."));
         continue;
      }
      else if (recvbuf[i] == FR_ESC)
      {
         _packbuf._esc = 1;
         continue;
      }
      // add data
      if (_packbuf._cnt < _packbuf._len)
      {
         _packbuf._buf[_packbuf._cnt++] = recvbuf[i];
      }
   }
}


int FramedStream::sendFramedPacket(const void* buffer, int l)
// send packet
{
   unsigned char sbuf[l + 10 + ((l + 1) / 2)];
   unsigned char* buf = (unsigned char*)buffer;
   int datalen = l;
   int cnt = 0;
   sbuf[cnt++] = FR_ESC;
   sbuf[cnt++] = TR_START;
   while (l > 0)
   {
      sbuf[cnt++] = *buf;
      if (*buf == FR_ESC)
      {
         sbuf[cnt++] = TR_ESC;
      }
      l--;
      buf++;
      if (cnt >= (int)sizeof(sbuf) - 3)
      {
         // Cache voll
         if (_fktPack)
         {
            int bytesSent = _fktPack->onSendFramedData(sbuf, cnt);
            if (bytesSent == -1)
            {
               ETG_TRACE_ERR_THR(("FramedStream-ERROR: Write cache len=%d", cnt));
               return -1;
            }
         }
         cnt = 0;
      }
   }
   // und den Rest auch raus bitte
   sbuf[cnt++] = FR_ESC;
   sbuf[cnt++] = TR_END;
   if (_fktPack)
   {
      int bytesSent = _fktPack->onSendFramedData(sbuf, cnt);
      if (bytesSent == -1)
      {
         ETG_TRACE_ERR_THR(("FramedStream-ERROR: Write len=%d", cnt));
         return (-1);
      }
   }
   return (datalen);
}


void FramedStream::PackRecvBuf::init()
{
   _len = sizeof(_buf);
   _esc = 0;
   _cnt = 0;
   memset(_buf, 0, sizeof(_buf));
}


/*
void FramedStream::processReceive()
{
   unsigned char recvbuf[200];
   int l;

   while ((l=_socket.receive(recvbuf, sizeof(recvbuf), false)) > 0)
   {
      addIncommingData(recvbuf,l);
   }
}


*/
}//util
}//hmibase
