/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/Error.h"
#include <cstdio>
#include <cstring>
#include <errno.h>

namespace hmibase {
namespace util {

void Error::reset()
{
   errno = 0;
}


bool Error::is()
{
   return errno != 0;
}


int Error::get()
{
   return errno;
}


SimpleString Error::getString()
{
   return getString(errno);
}


SimpleString Error::getString(int errorCode)
{
   return strerror(errorCode);
}


SimpleString Error::getMessage()
{
   return getMessage(errno);
}


SimpleString Error::getMessage(int errorCode)
{
   return SimpleString::format("error=%d (%s)\n", errorCode, getString(errorCode).cPtr());
}


} // namespace
} // namespace
